<?php
session_start();

// Verificar si el usuario está logueado y tiene permisos para ver esta página
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: dashboard.php');
    exit;
}

// Conectar a la base de datos
require_once 'conexiones/conexion.php';

// Obtener los usuarios registrados
$stmt = $pdo->prepare("SELECT id, email, role, created_at FROM usuarios");
$stmt->execute();
$usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Procesar la acción de editar un usuario
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_user'])) {
    $usuario_id = $_POST['user_id'];
    $email = $_POST['email'];
    $role = $_POST['role'];

    // Actualizar los datos del usuario
    $stmt = $pdo->prepare("UPDATE usuarios SET email = ?, role = ? WHERE id = ?");
    $stmt->execute([$email, $role, $usuario_id]);

    header('Location: solicitudes/gestion_editar_usuarios.php');
    exit;
}

// Procesar la acción de eliminar un usuario
if (isset($_GET['delete'])) {
    $usuario_id = $_GET['delete'];

    // Eliminar el usuario de la base de datos
    $stmt = $pdo->prepare("DELETE FROM usuarios WHERE id = ?");
    $stmt->execute([$usuario_id]);

    header('Location: solicitudes/gestion_eliminar_usuarios.php');
    exit;
}

// Procesar la acción de agregar un nuevo usuario
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['add_user'])) {
    $email = $_POST['email'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $role = $_POST['role'];

    // Insertar el nuevo usuario en la base de datos
    $stmt = $pdo->prepare("INSERT INTO usuarios (email, password, role, created_at) VALUES (?, ?, ?, NOW())");
    $stmt->execute([$email, $password, $role]);

    header('Location: gestion_usuarios.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Usuarios</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .content {
            padding: 2rem;
        }
        .table-responsive {
            margin-top: 1rem;
        }
        @media (max-width: 768px) {
            .content {
                padding: 1rem;
            }
            .table thead {
                display: none;
            }
            .table tr {
                display: block;
                margin-bottom: 1rem;
            }
            .table td {
                display: flex;
                justify-content: space-between;
                padding: 0.5rem;
                border: none;
                border-bottom: 1px solid #ddd;
            }
            .table td::before {
                content: attr(data-label);
                font-weight: bold;
                text-transform: uppercase;
            }
        }
    </style>
</head>
<body>
    <?php include "menuajuste.php"; ?>

    <div class="content">
        <h1 class="text-center mb-4">Gestión de Usuarios</h1>

        <!-- Formulario para agregar nuevo usuario -->
        <div class="mb-4">
            <h3>Agregar Nuevo Usuario</h3>
            <form action="gestion_usuarios.php" method="POST">
                <div class="mb-3">
                    <label for="email" class="form-label">Email</label>
                    <input type="email" class="form-control" id="email" name="email" required>
                </div>
                <div class="mb-3">
                    <label for="password" class="form-label">Contraseña</label>
                    <input type="password" class="form-control" id="password" name="password" required>
                </div>
                <div class="mb-3">
                    <label for="role" class="form-label">Rol</label>
                    <select class="form-select" id="role" name="role" required>
                        <option value="admin">Administrador</option>
                        <option value="user">Usuario</option>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary" name="add_user">Agregar Usuario</button>
            </form>
        </div>

        <!-- Tabla de usuarios -->
        <h3>Usuarios Registrados</h3>
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Email</th>
                        <th>Rol</th>
                        <th>Fecha de Creación</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($usuarios as $usuario): ?>
                        <tr>
                            <td data-label="Email"><?= htmlspecialchars($usuario['email']) ?></td>
                            <td data-label="Rol"><?= htmlspecialchars($usuario['role']) ?></td>
                            <td data-label="Fecha de Creación"><?= htmlspecialchars($usuario['created_at']) ?></td>
                            <td data-label="Acciones">
                                <button class="btn btn-warning btn-sm" onclick="openEditModal(<?= htmlspecialchars(json_encode($usuario)) ?>)">Editar</button>
                                <button class="btn btn-danger btn-sm" onclick="openDeleteModal(<?= $usuario['id'] ?>)">Eliminar</button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal para Editar Usuario -->
    <div class="modal fade" id="editUserModal" tabindex="-1" aria-labelledby="editUserModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="editUserForm" method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title" id="editUserModalLabel">Editar Usuario</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="user_id" id="editUserId">
                        <div class="mb-3">
                            <label for="editEmail" class="form-label">Email</label>
                            <input type="email" class="form-control" id="editEmail" name="email" required>
                        </div>
                        <div class="mb-3">
                            <label for="editRole" class="form-label">Rol</label>
                            <select class="form-select" id="editRole" name="role" required>
                                <option value="admin">Administrador</option>
                                <option value="user">Usuario</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary" name="update_user">Guardar Cambios</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal para Confirmar Eliminación -->
    <div class="modal fade" id="deleteUserModal" tabindex="-1" aria-labelledby="deleteUserModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="deleteUserForm" method="GET">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteUserModalLabel">Confirmar Eliminación</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>¿Estás seguro de que deseas eliminar este usuario?</p>
                        <input type="hidden" name="delete" id="deleteUserId">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Eliminar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        function openEditModal(usuario) {
            document.getElementById('editUserId').value = usuario.id;
            document.getElementById('editEmail').value = usuario.email;
            document.getElementById('editRole').value = usuario.role;
            new bootstrap.Modal(document.getElementById('editUserModal')).show();
        }

        function openDeleteModal(userId) {
            document.getElementById('deleteUserId').value = userId;
            new bootstrap.Modal(document.getElementById('deleteUserModal')).show();
        }
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
